<?php

use Inside\Content\Exceptions\ContentCreateFailedException;
use Inside\Host\Bridge\BridgeContent;

if (! function_exists('get_entity')) {
    function get_entity(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
    {
        $name = trim(ucwords(strtolower($record[$column])));

        if (empty($name)) {
            return null;
        }

        $query = call_user_func('Inside\\Content\\Models\\Contents\\' . \Illuminate\Support\Str::studly($bundle) . '::query');

        $entity = $query->where('title', $name)->first();

        if ($entity) {
            return [$entity->uuid];
        }

        $uuidBridge = $bridge->contentInsert($bundle, [
            'title' => $name,
            'type' => 'node',
            'bundle' => $bundle,
            'uid' => 1,
        ]);

        if ($uuidBridge) {
            return [$uuidBridge];
        }

        return null;
    }
}

return [
    'files' => [
        'hare' => [
            'path' => __DIR__ . '/../../../../imports/annuaire.xlsx',
            'fields' => [
                'name' => 'email',
                'mail' => 'email',
                'firstname' => fn ($record) => ucwords(strtolower(trim($record['prenom']))),
                'lastname' => fn ($record) => ucwords(strtolower(trim($record['nom']))),
                'function' => fn ($record) => ucwords(strtolower(trim($record['fonction']))),
                'phone' => fn ($record) => trim($record['phone 1']),
                'mobile_phone' => fn ($record) => trim($record['phone 2']),
                'business' => fn ($record, BridgeContent $bridge) => get_entity($record, $bridge, 'business', 'entreprise'),
                'address_pro' => 'adresse professionnelle',
                'service' => fn ($record, BridgeContent $bridge) => get_entity($record, $bridge, 'service', 'service'),
                'activity_domain' => fn ($record, BridgeContent $bridge) => get_entity($record, $bridge, 'activity_domain', 'domaine d\'activité'),
                'status' => fn () => 1,
                'external_account' => fn () => 0
            ],
            'original_fields' => [
                'email' => 'mail',
                'prenom' => 'firstname',
                'nom' => 'lastname',
                'fonction' => 'function',
                'phone 1' => 'phone',
                'phone 2' => 'mobile',
                'entreprise' => 'company',
                'adresse professionnelle' => 'address',
                'service' => 'word',
                'domaine d\'activité' => 'word',
            ]
        ],
    ],
];
