export default {
  globals: {
    icons: {
      bookmark: 'rate',
      bookmarkFill: 'rate-fill'
    },
    inputs: {
      date: {
        interval: {
          m: 1
        }
      }
    },
    notificationRedirectionsContentTypes: ['news', 'directions_news'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      }),
      directionsNews: async ({ data }) => ({
        name: 'NewsDirectionPage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-customs': {
    templates: {
      fullContent: {
        directionsNews: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        },
        newMembers: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        }
      }
    }
  },
  'inside-commons': {
    banner: {
      imageKey: 'image'
    }
  },
  'inside-birthdays': {
    offset: 7,
    dateFormat: 'DD/MM'
  },
  'inside-catalog': {
    rootRoute: {
      fr: 'les-projets'
    }
  },
  'inside-events': {
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-ged': {
    useBookmarks: true,
    useV2: true,
    rootRoute: {
      fr: 'bibliotheque-de-ressources'
    }
  },
  'inside-news': {
    bookmarkEnabled: false,
    showBookmarks: false
  },
  'inside-teams': {
    rootRoute: {
      fr: 'communautes'
    }
  },
  'inside-users': {
    allowAvatarEdition: false,
    shortcuts: {
      max: 4,
      content: 'tools_shortcuts'
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  }
}
