import { spacePagesCategoriesFilters } from '../constants/spaces'

export const newsCategories = {
  news_categories: {
    path: 'data',
    disabledOn: ['NewsListingPage'],
    href: item => ({
      name: 'NewsListingPage',
      query: { news_categories: item.uuid }
    })
  },
  direction: {
    path: 'data',
    href: data => (data.slug ? `/${data.slug[0]}/actualites` : '/')
  }
}

export const getPagesCategoriesFilters = slug => ({
  ...spacePagesCategoriesFilters,
  spaces: { 'slug:eq': slug }
})
