import { http } from '@inside-library/helpers/Http'

const fetchIdeas = async ({ $route }) => {
  try {
    const { data } = await http.get('content/ideas_pages', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'image',
        'cta_link',
        'cta_title',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchIdeas }
