import { http } from '@inside-library/helpers/Http'

const fetchDirections = async ({ $route }) => {
  try {
    const { data } = await http.get('content/direction', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content',
        'content_type',
        'slug',
        {
          users: {
            fields: [
              'uuid',
              'phone',
              'firstname',
              'lastname',
              'function',
              'image',
              'mobile'
            ]
          }
        }
      ],
      filters: {
        'status:eq': 1,
        slug: $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchNewsDirections = async ({ $route }) => {
  try {
    const slug = $route.params.slug
    const { data } = await http.get('content/directions_news', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'updated_at',
        'chapo',
        'slug',
        'content_type',
        { reactions: ['count', { users: ['uuid'] }] },
        {
          comments: {
            fields: ['count']
          }
        },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1 }
          }
        },
        {
          direction: {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'status:eq': 1 }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()',
        limit: 4,
        direction: {
          'slug:eq': slug
        }
      }
    })

    return { slug, data }
  } catch (err) {
    throw new Error(err)
  }
}

const fetchDirectionUsers = async ({ $route }) => {
  try {
    const { data: dataUsers } = await http.get('content/users', {
      fields: [
        'uuid',
        'title',
        'slug',
        'admin',
        'image',
        'firstname',
        'lastname',
        'content_type',
        'phone',
        'mobile',
        'function',
        { workplace: ['uuid', 'title'] },
        { direction: ['uuid', 'title'] }
      ],
      filters: {
        direction: {
          'slug:eq': $route.params.slug
        },
        'status:eq': 1,
        'is_maintenance:eq': 0
      }
    })

    const { data: dataDirection } = await http.get('content/direction', {
      fields: ['uuid', 'title', 'slug'],
      filters: {
        'slug:eq': $route.params.slug
      }
    })

    return { dataUsers: dataUsers, dataDirection: dataDirection[0] }
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchDirections, fetchNewsDirections, fetchDirectionUsers }
