import { http } from '@inside-library/helpers/Http'

const fetchAdvantages = async ({ props, $route }) => {
  try {
    const { data } = await http.get('content/custom', {
      fields: ['uuid', 'title', 'content_type', 'admin', 'introduction'],
      filters: {
        'status:eq': 1,
        'custom_slug:eq': `advantages-${props.advantageType}`
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchAdvantages }
