import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import ProjectItem from '../components/projects/ProjectItem'
import FlashInfoModal from '../components/modals/FlashInfoModal'
import InfrastructuresModal from '../components/modals/InfrastructuresModal'
import CseModal from '../components/modals/CseModal'
import DirectionsModal from '../components/modals/DirectionsModal'
import SyndicatesModal from '../components/modals/SyndicatesModal'
import SimpleModal from '../components/modals/SimpleModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('project-item-customs', ProjectItem)
    app.component('flash-info-modal', FlashInfoModal),
    app.component('infrastructures-modal', InfrastructuresModal)
    app.component('cse-modal', CseModal),
    app.component('directions-modal', DirectionsModal)
    app.component('syndicates-modal', SyndicatesModal),
    app.component('simple-modal', SimpleModal)
  })
}
