import { http } from '@inside-library/helpers/Http'

const fetchNewsSlider = async () => {
  try {
    const { data } = await http.get('content/news,directions_news', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'updated_at',
        'chapo',
        'slug',
        'content_type',
        'is_featured',
        { reactions: ['count', { users: ['uuid'] }] },
        { comments: ['count'] },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': 1 }
          }
        },
        { direction: ['uuid', 'title', 'slug'] }
      ],
      filters: {
        'status:eq': 1,
        'is_featured:eq': 1,
        sort: ['is_first:desc', 'published_at:desc'],
        'published_at:lte': 'now()',
        limit: 4
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchMovements = async () => {
  try {
    const { data } = await http.get('content/new_members', {
      fields: ['uuid', 'title', 'slug', 'chapo', 'image', 'function'],
      filters: {
        'status:eq': 1,
        'published_at:lte': 'now()',
        sort: 'published_at:desc',
        limit: 4
      }
    })

    return data || []
  } catch (err) {
    throw new Error(err)
  }
}

const fetchProjects = async () => {
  try {
    const { data } = await http.get('content/projects', {
      fields: [
        'uuid',
        'title',
        'slug',
        'content_type',
        'image',
        {
          project_status: {
            fields: ['uuid', 'title']
          }
        },
        {
          project_types: {
            fields: ['uuid', 'title']
          }
        }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        limit: 3
      }
    })
    return data || []
  } catch (err) {
    throw new Error(err)
  }
}

const fetchCardLink = async () => {
  try {
    const { data } = await http.get('content/cards_links', {
      fields: [
        'uuid',
        'title',
        'admin',
        'image',
        'link',
        'published_at',
        'content_type'
      ],
      filters: { 'status:eq': 1, sort: 'published_at:desc', limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchNewsSlider, fetchMovements, fetchProjects, fetchCardLink }
