import IdeasPage from '../pages/IdeasPage'
import { fetchIdeas } from '../fetch/ideas'

import { syndicatesRoot, cseRoot } from '../constants/syndicates'

import ProjectPage from '../pages/projects/ProjectPage'
import ProjectDirectoryPage from '../pages/projects/ProjectDirectoryPage'
import ProjectGedPage from '../pages/projects/ProjectGedPage'
import {
  fetchProject,
  fetchProjectUsers,
  fetchProjectDocuments
} from '../fetch/projects'

import AdvantagesPage from '../pages/AdvantagesPage'
import { fetchAdvantages } from '../fetch/advantages'

import DirectionPage from '../pages/directions/DirectionPage'
import DirectionsListingUsersPage from '../pages/directions/DirectionsListingUsersPage'
import { fetchDirections, fetchDirectionUsers } from '../fetch/directions'

import SpacePage from '../pages/spaces/SpacePage'
import SpacePagesPage from '../pages/spaces/SpacePagesPage'
import {
  fetchSpacePage,
  fetchSpacePagesPage
} from '../components/spaces/spaces'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsDirectionListingPage',
    path: '/directions/:slug/actualites',
    component: () => import('../pages/news/NewsDirectionListingPage')
  },
  {
    name: 'NewsDirectionPage',
    path: '/actualites-direction/:slug',
    component: () => import('../pages/news/NewsDirectionPage')
  },
  {
    name: 'NewMembersListingPage',
    path: '/arrivees',
    component: () => import('../pages/news/NewMembersListingPage')
  },
  {
    name: 'NewMembersPage',
    path: '/arrivees/:slug',
    component: () => import('../pages/news/NewMembersPage')
  },
  {
    name: 'EventsCalendarPage',
    path: {
      fr: '/evenements-de-l-entreprise'
    },
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    path: {
      fr: '/annuaire-des-collaborateurs'
    },
    component: () => import('../pages/directory/DirectoryPage'),
    meta: {
      disabled: false
    }
  },
  {
    name: 'InfrastructuresDirectoryPage',
    path: {
      fr: '/infrastructures'
    },
    component: () => import('../pages/directory/InfrastructuresDirectoryPage'),
    meta: {
      disabled: false
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    component: () => import('../pages/GedPage')
  },
  {
    name: 'IdeasPage',
    path: '/idee/:slug',
    component: withFetch(IdeasPage, { size: 'xxl', watch: true })(fetchIdeas)
  },
  {
    name: 'TeamsListingPage',
    component: () => import('../pages/TeamsListingPage')
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    component: () => import('../pages/ToolsPage'),
    path: '/outils'
  },
  {
    name: 'ProjectsListingPage',
    path: '/les-projets',
    component: () => import('../pages/projects/ProjectsListingPage')
  },
  {
    name: 'ProjectPage',
    path: '/les-projets/:slug',
    component: withFetch(ProjectPage, { size: 'xxl', watch: true })(
      fetchProject
    )
  },
  {
    name: 'ProjectDirectoryPage',
    path: '/les-projets/:slug/equipe',
    component: withFetch(ProjectDirectoryPage, {
      size: 'xxl',
      watch: true
    })(fetchProjectUsers)
  },
  {
    name: 'ProjectGedPage',
    path: '/les-projets/:slug/documents',
    component: withFetch(ProjectGedPage, {
      size: 'xxl',
      watch: true
    })(fetchProjectDocuments)
  },
  {
    name: 'ProfileUserPage',
    component: () => import('../pages/ProfileUserPage')
  },
  {
    name: 'SyndicatesListingPage',
    component: () => import('../pages/syndicates/SyndicatesListingPage'),
    path: {
      fr: '/syndicats'
    }
  },
  {
    name: 'SyndicatesPage',
    component: () => import('../pages/syndicates/SyndicatesPage'),
    path: {
      fr: `${syndicatesRoot.fr}/:slug`
    }
  },
  {
    name: 'SyndicatesUsersPage',
    component: () => import('../pages/syndicates/SyndicatesUsersPage'),
    path: {
      fr: `${syndicatesRoot.fr}/:slug/collaborateurs`
    }
  },
  {
    name: 'SyndicatesSimplePage',
    component: () => import('../pages/syndicates/SyndicatesSimplePage.vue'),
    path: {
      fr: `${syndicatesRoot.fr}/:slug/pages/:page`
    }
  },
  {
    name: 'CsePage',
    component: () => import('../pages/syndicates/SyndicatesPage'),
    path: {
      fr: `${cseRoot.fr}`
    }
  },
  {
    name: 'CseUsersPage',
    component: () => import('../pages/syndicates/SyndicatesUsersPage'),
    path: {
      fr: `${cseRoot.fr}/collaborateurs`
    }
  },
  {
    name: 'CsePagesPage',
    component: () => import('../pages/syndicates/SyndicatesSimplePage.vue'),
    path: {
      fr: `${cseRoot.fr}/pages/:page`
    }
  },
  {
    name: 'AdvantagesCePage',
    path: '/avantages-ce',
    component: withFetch(AdvantagesPage, { size: 'xxl', watch: true })(
      fetchAdvantages
    ),
    props: {
      advantageType: 'ce'
    },
    meta: { disabled: false }
  },
  {
    name: 'AdvantagesGroupePage',
    path: '/avantages-groupe',
    component: withFetch(AdvantagesPage, { size: 'xxl', watch: true })(
      fetchAdvantages
    ),
    props: {
      advantageType: 'groupe'
    },
    meta: { disabled: false }
  },
  {
    name: 'DirectionsListingPage',
    path: '/directions',
    component: () => import('../pages/directions/DirectionsListingPage')
  },
  {
    name: 'DirectionPage',
    path: '/directions/:slug',
    component: withFetch(DirectionPage, { size: 'xxl', watch: true })(
      fetchDirections
    )
  },
  {
    name: 'DirectionsListingUsers',
    path: '/directions/:slug/collaborateurs',
    component: withFetch(DirectionsListingUsersPage, {
      size: 'xxl',
      watch: true
    })(fetchDirectionUsers)
  },
  {
    name: 'ManagerSpacePage',
    path: '/mon-espace-manager',
    component: () => import('../pages/ManagerSpacePage')
  },
  {
    name: 'SpacePage',
    path: '/espace/:slug',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpacePage),
    meta: { content: 'spaces' }
  },
  {
    name: 'SpacePagesPage',
    path: '/espace/:slug/pages',
    component: withFetch(SpacePagesPage, { size: 'xxl' })(fetchSpacePagesPage)
  },
  {
    name: 'SimplePage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
