import { http } from '@inside-library/helpers/Http'

export default {
  cardsLinks: {
    add: () => ({
      name: 'HomePage'
    })
  },
  syndicates: {
    add: ({ data }) => ({
      name: 'SyndicatesPage',
      params: {
        slug: data.slug[0]
      }
    })
  },
  syndicatesPages: {
    fields: [{ syndicates: ['slug'] }],
    add: ({ data }) => ({
      name: 'SyndicatesSimplePage',
      params: {
        slug: data.syndicates.data[0].slug[0],
        page: data.slug[0]
      }
    })
  },
  syndicatesFolders: {
    add: async ({ data, fields }) => {
      const syndicate = fields
        ? fields.syndicates[0]
        : data.syndicates.data[0].uuid

      try {
        const { data: syndicateData } = await http.get('content/syndicates', {
          fields: ['slug'],
          filters: {
            'uuid:eq': syndicate
          }
        })

        return {
          name: 'SyndicatesPage',
          params: { slug: syndicateData[0].slug[0] },
          query: { folder: data.uuid }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  syndicatesDocuments: {
    add: async ({ fields }) => {
      try {
        const { data: syndicateFolderData } = await http.get(
          'content/syndicates_folders',
          {
            fields: [{ syndicates: { fields: ['slug'] } }],
            filters: {
              'uuid:eq': fields.syndicates_folders[0]
            }
          }
        )

        return {
          name: 'SyndicatesPage',
          params: { slug: syndicateFolderData[0].syndicates.data[0].slug[0] },
          query: { folder: fields.syndicates_folders }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  direction: {
    add: ({ data }) => ({
      name: 'DirectionPage',
      params: { slug: data.slug[0] }
    })
  },
  directionsNews: {
    add: ({ data }) => ({
      name: 'NewsDirectionPage',
      params: { slug: data.slug[0] }
    })
  },
  ideasPages: {
    add: ({ data }) => ({
      name: 'IdeasPage',
      params: { slug: data.slug[0] }
    })
  },
  projects: {
    add: ({ data }) => ({
      name: 'ProjectPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projectsDocuments: {
    add: async ({ fields }) => {
      try {
        const { data: projectData } = await http.get('content/projects', {
          fields: ['slug'],
          filters: {
            'uuid:eq': fields.projects[0]
          }
        })

        return {
          name: 'ProjectGedPage',
          params: {
            slug: projectData[0].slug[0]
          },
          query: { folder: fields.project_folders }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  projectFolders: {
    add: async ({ data, fields }) => {
      try {
        const { data: projectData } = await http.get('content/projects', {
          fields: ['slug'],
          filters: {
            'uuid:eq': fields.projects[0]
          }
        })

        return {
          name: 'ProjectGedPage',
          params: {
            slug: projectData[0].slug[0]
          },
          query: { folder: data.uuid }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async data => {
      try {
        const { data: projectData } = await http.get(
          'content/project_folders',
          {
            filters: {
              'uuid:eq': data.uuid
            }
          }
        )

        const { data: projectSlug } = await http.get('content/projects', {
          fields: ['slug'],
          filters: {
            'uuid:eq': projectData[0].projects.data[0].uuid
          }
        })

        return {
          name: 'ProjectGedPage',
          params: {
            slug: projectSlug[0].slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  advantages: {
    add: async ({ fields }) => {
      let type = fields.advantageType.split('')
      type[0] = type[0].toUpperCase()
      type = type.join('')

      return {
        name: `Advantages${type}Page`
      }
    }
  },
  managerSpacesDocuments: {
    add: () => '/mon-espace-manager'
  },
  managerSpacesFolders: {
    add: () => '/mon-espace-manager'
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    })
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacePagesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: pagesCategoriesPage } = await http.get(
        'content/spaces_pages',
        {
          fields: ['uuid', { pages_categories: ['uuid', 'title'] }],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const { data: space } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': pagesCategoriesPage[0].pages_categories.uuid }
      })

      return {
        route: {
          name: 'SpacePagesPage',
          params: {
            slug: space[0].spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
