import insideConfig from './inside.config.js'
import BreakpointOverride from './plugins/BreakpointOverride'
import redirections from './redirections'
import routes from './router'
import i18n from './i18n'

import UserModal from '../inside-overrides/inside-users/modals/UserModal'
import ListingUsers from '../inside-overrides/inside-users/ListingUsers'
import HorizontalLayouts from '../inside-overrides/inside-layouts/HorizontalLayouts'

export default {
  name: 'inside-customs',
  init: app => {
    app.component('user-modal', UserModal)
    app.component('listing-users', ListingUsers)
    app.component('horizontal-layouts', HorizontalLayouts)
  },
  plugin: BreakpointOverride,
  insideConfig,
  routes,
  redirections,
  i18n
}
