import { http } from '@inside-library/helpers/Http'
import { getStatusFilters } from '@inside-library/helpers/Permissions'

export const fetchProject = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      fields: [
        'uuid',
        'title',
        'slug',
        'admin',
        'cover',
        'introduction',
        'content',
        'content_type',
        'disable_join_project',
        { reactions: { users: ['uuid', 'lastname'] } },
        {
          project_owner: ['uuid', 'lastname', 'firstname', 'image', 'email']
        },
        {
          project_status: ['uuid', 'title', 'color']
        },
        {
          projects_types: ['uuid', 'title']
        },
        {
          users: ['uuid', 'lastname', 'firstname', 'image', 'email']
        }
      ],
      filters: {
        'slug:eq': $route.params.slug,
        ...getStatusFilters('projects')
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchProjectUsers = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      fields: [
        'uuid',
        'title',
        'slug',
        'admin',
        {
          project_owner: [
            'uuid',
            'lastname',
            'firstname',
            'image',
            'email',
            'phone',
            'function',
            'mobile'
          ]
        },
        {
          users: [
            'uuid',
            'lastname',
            'firstname',
            'image',
            'phone',
            'function',
            'mobile',
            'email'
          ]
        }
      ],
      filters: { 'slug:eq': $route.params.slug, 'status:eq': 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchProjectDocuments = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      fields: ['uuid', 'title', 'slug'],
      filters: { 'slug:eq': $route.params.slug, 'status:eq': 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
