export default {
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { folders: ['title'] }
    ]
  },
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['uuid', 'lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  },
  infrastructures: {
    extendedUrl: ['uuid'],
    modalFields: ['image', 'title', 'address', 'phone', 'uuid', 'email']
  },
  manager_spaces_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { manager_spaces_folders: ['title'] }
    ]
  },
  modal: {
    modalFields: ['class', 'content']
  },
  projects_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'published_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { project_folders: ['title'] }
    ]
  },
  tools: {
    staticFields: ['title', 'tools_link', 'tree', 'color', 'status']
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'image',
      'firstname',
      'lastname',
      'function',
      'email',
      'phone',
      'mobile',
      'cse_phone',
      'cse_mobile',
      'syndicates_phone',
      'syndicates_mobile',
      'college',
      'commission',
      'member',
      {
        direction: [
          'title',
          'uuid',
          {
            direction: ['uuid']
          }
        ]
      },
      {
        workplace: ['title', 'uuid']
      },
      'skills',
      'interest',
      'uuid'
    ]
  }
}
