<?php

namespace Inside\GSIA\Providers;

use Illuminate\Support\Facades\Lang;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\GSIA\Http\Middlewares\NewsMiddleware;
use Inside\GSIA\Listeners\ContentInsertedListener;
use Inside\GSIA\Listeners\ContentUpdatedListener;
use Inside\GSIA\Listeners\ReactionSubscribedListener;
use Inside\GSIA\Listeners\ReactionUnsubscribedListener;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Illuminate\Support\Facades\Event;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentUpdatedEvent::class => [
            ContentUpdatedListener::class,
        ],
        ContentInsertedEvent::class => [
            ContentInsertedListener::class,
        ],
        ReactionSubscribedEvent::class => [
            ReactionSubscribedListener::class,
        ],
        ReactionUnsubscribedEvent::class => [
            ReactionUnsubscribedListener::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->loadMigrationsFrom(__DIR__.'/../../database/migrations');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware(
            [
                NewsMiddleware::class,
            ]
        );
    }
}
