<?php

namespace Inside\GSIA\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;

class ReactionUnsubscribedListener implements ShouldQueue
{
    public function handle(ReactionUnsubscribedEvent $event): void
    {
        $reaction = $event->reaction;
        /** @var Content $model */
        $model = $reaction->reactionable;

        if ($model::class !== "Inside\Content\Models\Contents\Projects") {
            return;
        }

        $notificationTypes[] = NotificationType::where([
            'via' => 'web',
            'default' => true,
            'event' => 'Inside\Content\Events\ContentUpdatedEvent',
            'model' => 'Inside\Content\Models\Contents\Projects',
            'action' => 'update',
            'type' => 'global',
            'condition' => 'uuid:' . $model->uuid,
            'multiple' => true,
            'language' => true,
            'profile' => false
        ])->first();

        $notificationTypes[] = NotificationType::where(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentInsertedEvent',
                'model' => 'Inside\Content\Models\Contents\ProjectFolders',
                'action' => 'create',
                'type' => 'global',
                'condition' => 'projects:'.$model->uuid,
                'multiple' => false,
                'language' => true,
                'profile' => false
            ]
        )->first();

        /** @var Collection<NotificationType> $notificationTypes */
        $notificationTypes[] = NotificationType::where(
            [
                'via' => 'web',
                'default' => true,
                'event' => 'Inside\Content\Events\ContentInsertedEvent',
                'model' => 'Inside\Content\Models\Contents\ProjectsDocuments',
                'action' => 'create',
                'type' => 'global',
                'condition' => 'projects:'.$model->uuid,
                'multiple' => false,
                'language' => true,
                'profile' => false
            ]
        )->first();

        /** @var User $user */
        $user = $event->user;
        foreach ($notificationTypes as $notificationType) {
            NotificationSubscriber::where(
                [
                    'user_uuid'            => $user->uuid,
                    'notification_type_id' => $notificationType->id,
                ]
            )->delete();
        }
    }
}
