<?php

namespace Inside\GSIA\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Inside\Content\Models\Content;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Reaction\Events\ReactionSubscribedEvent;

class ReactionSubscribedListener implements ShouldQueue
{
    public function handle(ReactionSubscribedEvent $event): void
    {
        $reaction = $event->reaction;
        /** @var Content $model */
        $model = $reaction->reactionable;

        if ($model::class !== "Inside\Content\Models\Contents\Projects") {
            return;
        }

        $reactions = DB::table('inside_reactions')
            ->where('reactionable_type', 'Inside\Content\Models\Contents\Projects')
            ->where('type', 'follow')->get()->all();

        $array = [
            'projects' => DB::table('inside_notifications_types')
                ->where('model', 'Inside\Content\Models\Contents\Projects')
                ->where('action', 'update')->get()->all(),
            'folders' => DB::table('inside_notifications_types')
                ->where('model', 'Inside\Content\Models\Contents\ProjectFolders')
                ->where('action', 'create')->get()->all(),
            'documents' => DB::table('inside_notifications_types')
                ->where('model', 'Inside\Content\Models\Contents\ProjectsDocuments')
                ->where('action', 'create')->get()->all(),
        ];

        try {
            foreach ($reactions as $reaction) {
                foreach ($array as $types) {
                    foreach ($types as $type) {
                        if ($type->condition == "uuid:" . $reaction->reactionable_uuid || $type->condition == "projects:" . $reaction->reactionable_uuid) {
                            NotificationSubscriber::firstOrCreate([
                                'user_uuid' => $reaction->user_uuid,
                                'notification_type_id' => $type->id,
                            ]);
                            break;
                        }
                    }
                }
            }
        } catch (\Exception $exception) {
            Log::error($exception->getMessage());
        }
    }
}
