<?php

namespace Inside\GSIA\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Permission\Models\User;

class NewsMiddleware
{
    /**
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        $path  = $request->path();
        if (strpos($path, 'api/v1/form/news') !== 0) {
            return $response;
        }

        $datas = json_decode($response->getContent(), true);
        if ($datas === null || !Auth::check() || !isset($datas['data'])) {
            return $response;
        }

        /** @var \Inside\Authentication\Models\User $user */
        $user = Auth::user();

        foreach ($datas['data'] as &$element) {
            if (isset($element['fields']) && is_array($element['fields'])) {
                foreach ($element["fields"] as $key => &$field) {
                    if ($field["name"] === "is_first") {
                        if ($user->hasRole('Communication') || $user->hasRole('super_administrator')
                            || $user->hasRole('administrator')
                        ) {
                            unset($element["fields"][$key]);
                        }
                    }
                }
            }
        }
        $response->setContent(json_encode($datas));

        return $response;
    }
}
