<?php

namespace Inside\GSIA\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\FlashInfo;
use Inside\Reaction\Facades\Reactions;
use Laravel\Lumen\Routing\Controller;

class ReactionController extends Controller
{
    public function reaction(Request $request): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();
        $userUuid = $user->uuid;
        $dataUuid = $request->input('uuid');

        // Clean old reaction for $dataUuid
        DB::table('inside_reactions')->where('type', 'flashinfo')->where('user_uuid', $userUuid)->where(
            'reactionable_uuid',
            $dataUuid
        )->where('reactionable_type', FlashInfo::class)->delete();

        // Get flash info
        $flashInfo = FlashInfo::findOrFail($dataUuid);

        // Create a new reaction for flashinfo
        return new JsonResponse(
            Reactions::create(
                [
                    'user_uuid' => $userUuid,
                    'reactionable_uuid' => $dataUuid,
                    'reactionable_type' => FlashInfo::class,
                    'type' => 'flashinfo',
                    'langcode' => $flashInfo->langcode,
                ],
                [],
                false
            )
        );
    }
}
