<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Inside\Host\Bridge\BridgeContent;
use Inside\Layout\Models\LayoutPath;
use Inside\Layout\Models\Layout;

class SeedCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        collect([
            ['title' => 'Actualités des nouveaux arrivants', 'custom_slug' => 'new-members', 'redirection_page' => 'NewMembersListingPage'],
            ['title' => 'Mon espace manager', 'custom_slug' => 'manager-space', 'redirection_page' => 'ManagerSpacePage'],
            ['title' => 'Annuaire des collaborateurs', 'custom_slug' => 'directory', 'redirection_page' => 'DirectoryPage'],
            ['title' => 'Actualités de direction', 'custom_slug' => 'directions-news', 'redirection_page' => 'NewsDirectionsListingPage'],
        ])->each(fn ($custom) => $bridge->contentInsert(type: 'custom', data: $custom, fromCli: true));

        collect([
            ['title' => 'Actualités', 'custom_slug' => 'news', 'redirection_page' => 'NewsListingPage'],
            ['title' => 'Infrastructures', 'custom_slug' => 'infrastructure-directory', 'redirection_page' => 'InfrastructuresDirectoryPage'],
            ['title' => 'Les projets', 'custom_slug' => 'projects-listing', 'redirection_page' => 'CatalogPage'],
            ['title' => 'Evènements de l\'entreprise', 'custom_slug' => 'calendar', 'redirection_page' => 'EventsCalendarPage'],
            ['title' => 'Avantages CSE', 'custom_slug' => 'advantages-ce', 'redirection_page' => 'AdvantagesCePage'],
            ['title' => 'Avantages Groupe', 'custom_slug' => 'advantages-groupe', 'redirection_page' => 'AdvantagesGroupePage'],
        ])
            ->map(
                fn ($custom) => Arr::add($custom, 'uuid', DB::table('inside_content_custom')->where('title', $custom['title'])->first()?->uuid)
            )
            ->each(fn ($custom) => $bridge->contentUpdate(type: 'custom', data: $custom, fromCli: true));

        LayoutPath::with('layout')
            ->where('path', 'not like', 'inside_content_forms.%')
            ->get()
            ->pluck('layout')
            ->each(fn (Layout $layout) => $layout->delete());
    }
}
