<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\Notification;
use Inside\Notify\Notifications\HasSpecialUrl;

class FixDocumentsProjetcsNotifications extends Migration
{
    use HasSpecialUrl;

    /** @var mixed */
    protected $model = null;

    public function up(): void
    {
        // Fix existing notification type
        NotificationType::where(
            [
                ['via', '=', 'web'],
                ['default', '=', true],
                [
                    'event',
                    'in',
                    [
                        'Inside\Content\Models\Contents\ProjectsDocuments',
                        'Inside\Content\Models\Contents\ProjectsFolders',
                    ],
                ],
                ['type', '=', 'global'],
                ['multiple', '=', false],
                ['language', '=', true],
                ['profile', '=', false],
            ]
        )
            ->update(['data' => json_encode([
                'title' => "notifications.edit.project.title",
                'text' => "notifications.edit.project.text",
                'fields' => [
                    'projects' => ['title']
                ],
                'url' => 'RELATION:projects',
            ])]);

        // Fix existing notification
        Notification::where('notifiable_type', 'Inside\Content\Models\Contents\ProjectsDocuments')
            ->where('data', 'NOT LIKE', '%url%')
            ->each(function ($notification) {
                $data = $notification->data;
                $this->model = $notification->notifiable;

                $data['url'] = $this->prepareUrl('RELATION:projects');
                $notification->data = $data;
                $notification->save();
            });
    }
}
