<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Field;

class FixDrupalConfig extends Migration
{
    /** @var array */
    protected $overrides = [
        'status',
        'sticky',
        'uid',
        'title',
    ];

    protected function setToFrench(string $key): void
    {
        $config = DB::table('config')->where('name', $key)->first();
        if (!$config) {
            return;
        }
        $config = unserialize($config->data);
        $config['langcode'] = 'fr';
        if (array_key_exists('translatable', $config)) {
            $config['translatable'] = false;
        }
        DB::table('config')->where('name', $key)->update(
            [
                'data' => serialize($config),
            ]
        );
    }

    protected function setAllToFrench(string $cat, array $types): void
    {
        foreach ($types as $type) {
            if (in_array($type, ['comments'])) {
                continue;
            }

            if ($cat == 'paragraph') {
                $this->setToFrench('paragraphs.paragraphs_type.' . $type);
            } elseif ($type == 'users') {
                $this->setToFrench('user.settings');
                $this->setToFrench('user.mail');
                $this->setToFrench('user.flood');
            } else {
                $this->setToFrench($cat . '.type.' . $type);
            }
            $this->setToFrench('language.content_settings.node.' . $type);
            DB::table('config')->where(
                'name',
                'like',
                'core.base_field_override.' . ($type == 'users' ? 'user' : $cat) . '.' . ($type == 'users' ? 'user'
                    : $type) . '.%'
            )->delete();

            foreach (InsideSchema::getFieldListing($type) as $field) {
                if ($field == 'users') {
                    $field = 'user';
                }
                // Storage
                $this->setToFrench('field.storage.' . ($type == 'users' ? 'user' : $cat) . '.field_' . $field);

                // Field
                $this->setToFrench(
                    'field.field.' . ($type == 'users' ? 'user' : $cat) . '.' . ($type == 'users' ? 'user' : $type)
                    . '.field_' . $field
                );
            }
        }
    }

    public function up(): void
    {
        // Content types
        $this->setAllToFrench('node', InsideSchema::getContentTypes());

        // Sections
        $this->setAllToFrench('paragraph', InsideSchema::getSectionTypes());

        // Comments
        $this->setToFrench('comment.type.comments');
        foreach (
            ['comment.comment_body', 'comment.field_file', 'node.field_comments', 'node.field_comments_text',] as $storage
        ) {
            $this->setToFrench('field.storage.' . $storage);
        }
        foreach (['field_file', 'comment_body'] as $field) {
            $this->setToFrench('field.field.comment.comments.' . $field);
        }
        $this->setToFrench('language.content_settings.comment.comments');

        // Fix inside fields
        Field::each(
            function ($field) {
                $options = $field->options;
                $options['translatable'] = false;
                if (!isset($options['title']['fr']) || $options['title']['fr'] === null) { // @phpstan-ignore-line
                    $options['title']['fr'] = $options['title']['en'] ?? '';
                    unset($options['title']['en']);
                }
                if (! isset($options['description']['fr']) || $options['description']['fr'] === null) { // @phpstan-ignore-line
                    if (!is_array($options['description'])) {
                        $options['description'] = ['fr' => ''];
                    }
                    $options['description']['fr'] = $options['description']['en'] ?? '';
                    unset($options['description']['en']);
                }
                $field->options = $options;
                $field->save();
            }
        );
    }

    public function down(): void
    {
    }
}
