<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'name' => 'newsletters',
        'title' => [
            'fr' => 'Newsletters',
        ],
    ],
    'fields' => [
        [
            'name' => 'newsletter_introduction',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Introduction'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'news',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Actualités',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight'   => $weight++,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['news'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'events',
            'searchable'          => false,
            'translatable'        => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Événements',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight'   => $weight++,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['events'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'documents',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Documents',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight'   => $weight++,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['documents'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'newsletter_roles',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Rôles destinataires',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => $weight++,
                'hidden'   => true,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
    ]
];
