<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable'      => false,
        'searchable'        => true,
        'global_searchable' => true,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'news',
        'title'             => [
            'fr' => 'Actualités',
        ],
    ],
    'fields'  => [
        [
            'name'                => 'chapo',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => '',
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Chapô',
            ],
            'description'         => [
                'fr' => 'Je suis une description de chapo !',
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows'        => 5,
                    'placeholder' => '',
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'comments',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Commentaires',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::COMMENT_FIELD,
            'settings'            => [
                'comment_type' => 'comments',
                'cardinality'  => 1,
            ],
        ],
        [
            'name'                => 'content',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 3,
            'title'               => [
                'fr' => 'Contenu',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title'                  => 'Paragraph',
                    'title_plural'           => 'Paragraphs',
                    'edit_mode'              => 'closed',
                    'add_mode'               => 'dropdown',
                    'form_display_mode'      => 'default',
                    'default_paragraph_type' => '_none',
                ],
                'weight'   => 3,
            ],
            'type'                => BridgeContentType::SECTION_FIELD,
            'settings'            => [
                'target_type' => ['image_galery', 'visuals'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'direction',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Direction',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['direction'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Image',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::IMAGE_FIELD,
            'settings'            => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'   => '',
                    'alt'    => '',
                    'title'  => '',
                    'width'  => null,
                    'height' => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        [
            'name'                => 'is_featured',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Est mis en avant ?',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight'   => 1,
                'group'    => 'group_advanced_options',
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'is_first',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 6,
            'title'               => [
                'fr' => 'mettre en premier ?',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight'   => 6,
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'news_categories',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => true,
            'weight'              => 9,
            'title'               => [
                'fr' => 'Catégorie d\'actualité',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight'   => 9,
                'group'    => 'group_options',
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
        ],
    ],
];
