<?php

use Illuminate\Support\Facades\Log;

return [
    'schedule' => [
        'log_status' => function ($scheduler) {
            $scheduler->call(
                function () {
                    Log::info('Scheduler is running.');
                }
            )->hourly();
        },
        'user_import'     => function ($scheduler) {
            $scheduler->command('inside:user:import ldap --disable-not-imported --filter="(&(&(objectCategory=user)(objectClass=user)(company=*)(department=*)(!(description=Compte*))(&(objectCategory=person)(objectClass=user)(!(userAccountControl:1.2.840.113556.1.4.803:=2)))))"')->daily()->at('0:00')->after(function () {
                \Illuminate\Support\Facades\Artisan::call('inside:user:clean-references', ['content_types' => 'direction,workplace']);
            });
        },
    ],
];
