<?php

namespace Inside\GSIA\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\DB;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Host\Bridge\BridgeContent;
use Inside\Notify\Models\NotificationSubscriber;

/**
 * Inside package content service.
 *
 * @category Class
 * @package  Inside\GSIA\Listeners\ContentUpdatedListener
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentUpdatedListener implements ShouldQueue
{
    public function handle(ContentUpdatedEvent $event): void
    {
        $model = $event->model;

        if (get_class($model) == "Inside\Content\Models\Contents\Syndicates") {

            // Insert Project Folders and get uuid
            $folders = DB::table('inside_pivots')
                ->where('related_uuid', $model->uuid)
                ->where('related_type', 'Inside\Content\Models\Contents\Syndicates')
                ->where('parent_type', 'Inside\Content\Models\Contents\SyndicatesFolders')
                ->get(['id', 'parent_uuid'])->toArray();

            $foldersUuid = array_unique(array_map(function ($u) {
                return $u->parent_uuid;
            }, $folders));
            try {
                foreach ($foldersUuid as $folderUuid) {
                    $bridge = new BridgeContent();
                    $folder = \Inside\Content\Models\Contents\SyndicatesFolders::find($folderUuid);
                    if (!$folder) {
                        continue;
                    }
                    if ($folder->title === $model->title) {
                        return;
                    }
                    $uuid = $bridge->contentUpdate(
                        'syndicates_folders',
                        [
                            "bundle" => 'syndicates_folders',
                            "type" => "node",
                            "title" => $model->title,
                            "uuid" => $folder->uuid, // uuiid folder
                        ]
                    );
                }
            } catch (\Exception $exception) {
                var_dump($exception->getMessage());
            }
        }
    }
}
