<?php

namespace Inside\GSIA\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\DB;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Models\Contents\Projects;
use Inside\Host\Bridge\BridgeContent;
use Inside\Notify\Models\NotificationType;

/**
 * Inside package content service.
 *
 * @category Class
 * @package  Inside\GSIA\Listeners\ContentUpdatedListener
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentInsertedListener implements ShouldQueue
{
    public function handle(ContentInsertedEvent $event): void
    {
        $model = $event->model;
        if (get_class($model) == "Inside\Content\Models\Contents\Syndicates") {
            $bridge = new BridgeContent();
            // Insert Project Folders and get uuid
            $uuid = $bridge->contentInsert(
                'syndicates_folders',
                [
                    "bundle" => 'syndicates_folders',
                    "type" => "node",
                    "title" => $model->title,
                    "syndicates" => [$model->uuid],
                    "author" => $model->author
                ]
            );
        }

        if (get_class($model) == "Inside\Content\Models\Contents\Projects") {
            NotificationType::firstOrCreate(
                [
                    'via' => 'web',
                    'default' => true,
                    'event' => 'Inside\Content\Events\ContentUpdatedEvent',
                    'model' => 'Inside\Content\Models\Contents\Projects',
                    'action' => 'update',
                    'type' => 'global',
                    'condition' => 'uuid:'.$model->uuid,
                    'multiple' => false,
                    'language' => true,
                    'profile' => false
                ],
                [
                    'data' => [
                        'title' => "notifications.edit.project.title",
                        'text' => "notifications.edit.project.text",
                        'fields' => [
                            'projects' => ['title']
                        ],
                    ]
                ]
            );

            NotificationType::firstOrCreate(
                [
                    'via' => 'web',
                    'default' => true,
                    'event' => 'Inside\Content\Events\ContentInsertedEvent',
                    'model' => 'Inside\Content\Models\Contents\ProjectFolders',
                    'action' => 'create',
                    'type' => 'global',
                    'condition' => 'projects:'.$model->uuid,
                    'multiple' => false,
                    'language' => true,
                    'profile' => false
                ],
                [
                    'data' => [
                        'title' => "notifications.edit.project.title",
                        'text' => "notifications.project.add.element.text",
                        'fields' => [
                            'projects' => ['title'],
                            'url' => 'RELATION:projects',
                        ]
                     ]
                ]
            );

            NotificationType::firstOrCreate(
                [
                    'via' => 'web',
                    'default' => true,
                    'event' => 'Inside\Content\Events\ContentInsertedEvent',
                    'model' => 'Inside\Content\Models\Contents\ProjectsDocuments',
                    'action' => 'create',
                    'type' => 'global',
                    'condition' => 'projects:'.$model->uuid,
                    'multiple' => false,
                    'language' => true,
                    'profile' => false
                ],
                [
                    'data' => [
                        'title' => "notifications.edit.project.title",
                        'text' => "notifications.project.add.element.text",
                        'field' => ['title'],
                        'url' => 'RELATION:projects',
                    ]
                ]
            );
        }
    }
}
