<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class FixLikeCommentNotification extends Migration
{
    public function up(): void
    {
        /** @var NotificationType $type */
        $type = NotificationType::query()
            ->where('action', 'like')
            ->where('model', 'Inside\Content\Models\Contents\Comments')
            ->first();

        $type->data = [
            "title" => "notifications.reaction.like.comment.title",
            "text" => "notifications.reaction.like.comment.text",
            "icon" => "like",
            "fields" => [
                "notification-data.from" => ["firstname", "lastname"]
            ]
        ];

        $type->save();
    }

    public function down(): void
    {
    }
}
