<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Content\Models\Contents\Users;

class SubscribeAllUsersToLikeOnCommentNotification extends Migration
{
    public function up(): void
    {
        /** @var NotificationType $type */
        $type = NotificationType::query()->where('action', 'like')
            ->where('model', 'Inside\Content\Models\Contents\Comments')
            ->first();

        $type->default = 1;
        $type->save();

        Users::all()->each(function ($user) use ($type) {
            NotificationSubscriber::firstOrCreate(
                [
                    'user_uuid'            => $user->uuid,
                    'notification_type_id' => $type->id,
                ]
            );
        });
    }

    public function down(): void
    {
    }
}
