<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\ToolsShortcuts;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\ShortcutsMenus;
use Symfony\Component\Console\Helper\ProgressBar;
use Symfony\Component\Console\Output\ConsoleOutput;

class UpdateShortcutsMenusToTools extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $bridgeType = new BridgeContentType();

        $this->migrateContent('tools_shortcuts');

        $bridgeType->contentTypeCreateOrUpdateField('users', 'tools_shortcuts', [
            'name' => 'tools_shortcuts',
            'searchable' => true,
            'translatable' => false,
            'default' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Mes accès rapides',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 8,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tools_shortcuts'],
                'cardinality' => -1,
            ],
        ]);

        $this->finishUp();

        Artisan::call('models:rebuild');

        $bridge = new BridgeContent();
        $shortcuts = ShortcutsMenus::all();

        foreach ($shortcuts as $shortcut) {
            $uuid = null;
            $tool = ToolsShortcuts::query()
                ->where('title', $shortcut->title)
                ->where('tools_link', $shortcut->link)
                ->where('langcode', $shortcut->langcode)
                ->first();

            if (empty($tool)) {
                $uuid = $bridge->contentInsert('tools_shortcuts', [
                    'bundle' => 'tools_shortcuts',
                    'tools_link' => $shortcut->link,
                    'title' => $shortcut->title,
                    'image' => $shortcut->image,
                    'author' => $shortcut->author,
                    'type' => 'node',
                ]);
            } else {
                $uuid = $tool->uuid;
            }

            $users = $shortcut->reverseUsers;
            $output = new ConsoleOutput();
            $bar = new ProgressBar($output, $users->count());
            $bar->setFormat("%message%\n %current%/%max% [%bar%] %percent:3s%%");
            $bar->setMessage("Converting " . $shortcut->title . " shortcut for " . $users->count() . " users");
            $bar->start();

            foreach ($users as $user) {
                $tools = $user->toolsShortcuts;
                if (!$tools) {
                    continue;
                }
                $tools = $tools->pluck('uuid')->toArray();
                if (!in_array($uuid, $tools)) {
                    $tools[] = $uuid;
                    $bridge->contentUpdate('users', [
                        'uuid' => $user->uuid,
                        'tools_shortcuts' => $tools
                    ]);
                }
                $bar->advance();
            }
        }
        $dataDefaultTools = [];
        $oldDefaultShortcuts = Schema::getFieldOptions('users', 'shortcuts_menus');
        $nameShortcuts = $shortcuts->whereIn('uuid_host', $oldDefaultShortcuts['default']);

        foreach ($nameShortcuts as $nameShortcut) {
            $newTools = ToolsShortcuts::where('title', $nameShortcut->title)->first();
            $defaultTools['target_uuid'] = $newTools->uuid_host;
            array_push($dataDefaultTools, $defaultTools);
        }

        $bridgeType->contentTypeCreateOrUpdateField('users', 'tools_shortcuts', [
            'title' => [
                'fr' => 'Mes accès rapides',
            ],
            'default' => $dataDefaultTools,
        ]);
    }
}
