<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class HiddenNotificationsProfile extends Migration
{
    public function up(): void
    {
        $notifications = NotificationType::query()->where('via', 'web')
            ->where('profile', true)->where(function ($query) {
                $query->whereIn('action', ['join', 'follow', 'create']);
            })->where(function ($query) {
                $query->whereIn('event', ['Inside\Reaction\Events\ReactionSubscribedEvent', 'Inside\Notify\Events\ContentCreatedEvent']);
            })->get();

        $notifications->each(function ($notification) {
            if ($notification) {
                $notification->profile = false;
                $notification->save();
            }
        });
    }

    public function down(): void
    {
    }
}
