<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class FixDirectionsNewsNotificationAgain extends Migration
{
    public function up(): void
    {
        /** @var NotificationType|null $notificationType */
        $notificationType = NotificationType::query()
            ->where('model', 'Inside\Content\Models\Contents\DirectionsNews')
            ->where('action', 'create')->first();

        /** @var NotificationType|null $likeNotificationType */
        $likeNotificationType = NotificationType::query()
            ->where('action', 'like')
            ->where('condition', 'author:CURRENT_USER|content_type:news,events')->first();

        if ($notificationType) {
            $notificationType->via = "web";
            $notificationType->save();
        }

        if ($likeNotificationType) {
            $likeNotificationType->condition = "author:CURRENT_USER|content_type:news,events,directions_news";
            $likeNotificationType->save();
        }
    }

    public function down(): void
    {
    }
}
