<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class FixBirthdays extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        DB::table('inside_content_users')->where(DB::raw('YEAR(birthday)'), '>=', 2018)->get()->each(
            function ($user) use ($bridge) {
                $bridge->contentUpdate(
                    'users',
                    [
                        'uuid'     => $user->uuid,
                        'birthday' => null,
                    ]
                );
            }
        );

        $contentTypeBridge = new BridgeContentType();

        $contentTypeBridge->contentTypeUpdateField(
            'users',
            'birthday',
            [
                'name'                => 'birthday',
                'searchable'          => false,
                'translatable'        => false,
                'default'             => null,
                'search_result_field' => false,
                'required'            => false,
                'weight'              => 1,
                'front_field_config'  => '{"input": "input-day", "toDate": true}',
                'title'               => [
                    'fr' => 'Birthday',
                ],
                'description'         => [
                    'fr' => '',
                ],
                'widget'              => [
                    'type'     => BridgeContentType::TIMESTAMP_WIDGET,
                    'settings' => [],
                    'weight'   => 1,
                ],
                'type'                => BridgeContentType::TIMESTAMP_FIELD,
                'settings'            => [
                    'cardinality' => 1,
                ],
            ],
            1
        );
    }

    public function down(): void
    {
    }
}
