<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable'      => false,
        'searchable'        => true,
        'global_searchable' => true,
        'aliasable'         => false,
        'permissible'       => false,
        'categorizable'     => false,
        'name'              => 'users',
        'title'             => [
            'fr' => 'Utilisateurs',
        ],
    ],
    'fields'  => [
        [
            'name'                => 'birthday',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Birthday',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::TIMESTAMP_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'college',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'title'               => [
                'fr' => 'Collège',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 4,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'commission',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Commission',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 5,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'cse_mobile',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 8,
            'title'               => [
                'fr' => 'CSE Mobile',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 8,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'cse_phone',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 7,
            'title'               => [
                'fr' => 'CSE Téléphone',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 7,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'direction',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 7,
            'title'               => [
                'fr' => 'Direction',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [
                    'match_operator' => 'CONTAINS',
                    'size'           => 60,
                    'placeholder'    => '',
                ],
                'weight'   => 7,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['direction'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'emplacement',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Emplacement',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'firstname',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Prénom',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'function',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 9,
            'title'               => [
                'fr' => 'Fonction',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 9,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'groups',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Groupe',
            ],
            'description'         => [
                'fr' => 'Le groupe',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['groups'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'image',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 3,
            'title'               => [
                'fr' => 'Image',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'   => 3,
            ],
            'type'                => BridgeContentType::IMAGE_FIELD,
            'settings'            => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'   => '',
                    'alt'    => '',
                    'title'  => '',
                    'width'  => null,
                    'height' => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        [
            'name'                => 'interest',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 3,
            'title'               => [
                'fr' => 'Centres d\'intérêts',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows'        => 5,
                    'placeholder' => '',
                ],
                'weight'   => 3,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'is_gdpr_compliant',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'GDPR Compliant',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'is_maintenance',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Is a maintenance account ?',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'lastname',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Nom',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'left',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Est parti',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'member',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 6,
            'title'               => [
                'fr' => 'Membre',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 6,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'mobile',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 6,
            'title'               => [
                'fr' => 'Mobile',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 6,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 20,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'phone',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Téléphone',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 5,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'presentation',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Présentation',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'projects',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Projets',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['projects'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'services',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Service',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['services'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'shortcuts_menus',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Accès rapides',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['shortcuts'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'skills',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Compétences',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows'        => 5,
                    'placeholder' => '',
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'syndicates_mobile',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 6,
            'title'               => [
                'fr' => 'Syndicat Mobile',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 6,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'syndicates_phone',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 7,
            'title'               => [
                'fr' => 'Syndicat Téléphone',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
                'weight'   => 7,
            ],
            'type'                => BridgeContentType::TEXT_FIELD,
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'workplace',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 8,
            'title'               => [
                'fr' => 'Lieu de travail',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [
                    'match_operator' => 'CONTAINS',
                    'size'           => 60,
                    'placeholder'    => '',
                ],
                'weight'   => 8,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['workplace'],
                'cardinality' => -1,
            ],
        ],
    ],
];
