<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'listing_type' => 'content',
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'ideas_pages',
        'title' => [
            'fr' => 'Pages idées',
        ],
    ],
    'fields' => [
        [
            'name'                => 'introduction',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => '',
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Introduction',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows'        => 5,
                    'placeholder' => '',
                ],
                'weight'   => $weight++,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name' => 'banner',
            'type' => BridgeContentType::IMAGE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Bannière',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
            ],
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Contenu',
            ],
            'description' => [
                'fr' => ''
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraph',
                    'title_plural' => 'Paragraphs',
                    'edit_mode' => 'closed',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '_none',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => ['text', 'image', 'text_with_image', 'file', 'accordion', 'call_to_action', 'video', 'html', 'map'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'cta_title',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'type'                => BridgeContentType::TEXT_FIELD,
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Titre du CTA',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
            ],
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'cta_link',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'type'                => BridgeContentType::TEXT_FIELD,
            'weight'              => $weight,
            'title'               => [
                'fr' => 'Lien du CTA',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::INSIDE_LINK_WIDGET,
                'weight' => $weight++,
                'settings' => [
                    'size'        => 60,
                    'placeholder' => '',
                ],
            ],
            'settings'            => [
                'max_length'     => 255,
                'is_ascii'       => false,
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ]
    ]
];
