<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable'      => false,
        'searchable'        => true,
        'global_searchable' => true,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'directions_news',
        'title'             => [
            'fr' => 'Actualités de direction',
        ],
    ],
    'fields'  => [
        [
            'name'                => 'chapo',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => '',
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'title'               => [
                'fr' => 'Chapô',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows'        => 5,
                    'placeholder' => '',
                ],
                'weight'   => 4,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'comments',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'title'               => [
                'fr' => 'Commentaires',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'hidden' => true,
            ],
            'type'                => BridgeContentType::COMMENT_FIELD,
            'settings'            => [
                'comment_type' => 'comments',
                'cardinality'  => 1,
            ],
        ],
        [
            'name'                => 'content',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Contenu',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title'                  => 'Paragraphe',
                    'title_plural'           => 'Paragraphs',
                    'edit_mode'              => 'open',
                    'add_mode'               => 'dropdown',
                    'form_display_mode'      => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight'   => 5,
            ],
            'type'                => BridgeContentType::SECTION_FIELD,
            'settings'            => [
                'target_type' => ['image_galery', 'visuals'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'direction',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Direction',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['direction'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 3,
            'title'               => [
                'fr' => 'Image',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'   => 3,
            ],
            'type'                => BridgeContentType::IMAGE_FIELD,
            'settings'            => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'   => '',
                    'alt'    => '',
                    'title'  => '',
                    'width'  => null,
                    'height' => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        [
            'name'                => 'is_featured',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 26,
            'title'               => [
                'fr' => 'Mettre en avant sur la page d\'accueil',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight'   => 26,
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'is_first',
            'searchable'          => false,
            'translatable'        => true,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 27,
            'title'               => [
                'fr' => 'mettre en premier ?',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight'   => 27,
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
        [
            'name'                => 'news_categories',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Catégorie d\'actualités',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'show_hp_listing',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 28,
            'title'               => [
                'fr' => 'Afficher sur la page d\'actualités',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight'   => 28,
            ],
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'settings'            => [
                'cardinality' => 1,
            ],
        ],
    ],
];
