<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable'      => false,
        'searchable'        => false,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'direction',
        'title'             => [
            'fr' => 'Direction',
        ],
    ],
    'fields'  => [
        [
            'name'                => 'content',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Contenu',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title'                  => 'Paragraphe',
                    'title_plural'           => 'Paragraphs',
                    'edit_mode'              => 'open',
                    'add_mode'               => 'dropdown',
                    'form_display_mode'      => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight'   => 5,
            ],
            'type'                => BridgeContentType::SECTION_FIELD,
            'settings'            => [
                'target_type' => ['image_galery', 'visuals'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'cover',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'title'               => [
                'fr' => 'Image de couverture',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'   => 4,
            ],
            'type'                => BridgeContentType::IMAGE_FIELD,
            'settings'            => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'   => '',
                    'alt'    => '',
                    'title'  => '',
                    'width'  => null,
                    'height' => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        [
            'name'                => 'direction',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => null,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 27,
            'title'               => [
                'fr' => 'Direction parente',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [
                    'match_operator' => 'CONTAINS',
                    'size'           => 60,
                    'placeholder'    => '',
                ],
                'weight'   => 27,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => ['direction'],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 3,
            'title'               => [
                'fr' => 'Image de preview',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'   => 3,
            ],
            'type'                => BridgeContentType::IMAGE_FIELD,
            'settings'            => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'   => '',
                    'alt'    => '',
                    'title'  => '',
                    'width'  => null,
                    'height' => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        [
            'name'                => 'introduction',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => '',
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title'               => [
                'fr' => 'Introduction',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows'        => 5,
                    'placeholder' => '',
                ],
                'weight'   => 2,
            ],
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'settings'            => [
                'case_sensitive' => false,
                'cardinality'    => 1,
            ],
        ],
        [
            'name'                => 'users',
            'searchable'          => true,
            'translatable'        => false,
            'default'             => false,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Collaborateurs',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [
                    'match_operator' => 'CONTAINS',
                    'size'           => 60,
                    'placeholder'    => '',
                ],
                'weight'   => 1,
            ],
            'type'                => BridgeContentType::REFERENCE_FIELD,
            'settings'            => [
                'target_type' => 'user',
                'cardinality' => -1,
            ],
        ],
        [
            'name'                => 'weight',
            'searchable'          => false,
            'translatable'        => false,
            'default'             => 0,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 7,
            'title'               => [
                'fr' => 'Poids',
            ],
            'description'         => [
                'fr' => '',
            ],
            'widget'              => [
                'type'     => BridgeContentType::NUMBER_WIDGET,
                'settings' => [
                    'placeholder' => '',
                ],
                'weight'   => 7,
            ],
            'type'                => BridgeContentType::INTEGER_FIELD,
            'settings'            => [
                'unsigned'    => false,
                'size'        => 'normal',
                'cardinality' => 1,
            ],
        ],
    ],
];
