<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => false,
        'name' => 'cards_links',
        'title' => [
            'fr' => 'Carte avec lien',
        ],
    ],
    'fields' => [
        [
            'name' => 'background_color',
            'searchable' => false,
            'translatable' => false,
            'default' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => -1,
            'title' => [
                'fr' => 'Couleur de fond',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [
                    'size' => 50,
                    'placeholder' => '#ffffff',
                ],
                'weight' => -1,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'case_sensitive' => false,
                'is_ascii' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => -2,
            'title' => [
                'fr' => 'Image',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => -2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => null,
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'label_link',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => -3,
            'title' => [
                'fr' => 'Label du lien',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => -3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'case_sensitive' => false,
                'is_ascii' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => -4,
            'title' => [
                'fr' => 'Lien',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [
                    'size' => 2048,
                    'placeholder' => 'https//example.com',
                ],
                'weight' => -4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'case_sensitive' => false,
                'is_ascii' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
