import { http } from '@inside-library/helpers/Http'
import get from 'lodash/get'

export default {
  jobOffers: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' }),
    globalSearch: ({ data, vm }) => ({
      action: () => {
        vm.triggerModal(
          'offers',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
      }
    })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  pagesCategories: {
    fields: ['uuid', { spaces: ['slug'] }],
    add: ({ data }) => {
      return {
        name: 'SpacePage',
        params: {
          slug: data.spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/pages_categories', {
          fields: [
            {
              spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        const slug =
          get(data, [0, 'spaces', 'slug', 0]) ||
          get(data, [0, 'spaces', 'data', 0, 'slug', 0])

        return {
          name: 'SpacePage',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    }
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: ['uuid'] }],
    add: async ({ data }) => {
      try {
        const { data: pagesCategories } = await http.get(
          'content/pages_categories',
          {
            fields: [
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug'],
                  filters: { 'status:eq': 1 }
                }
              }
            ],
            filters: { 'uuid:eq': data.pages_categories.data[0].uuid }
          }
        )

        const slug = get(pagesCategories, [0, 'spaces', 'slug', 0])

        return {
          name: 'SpacePage',
          params: { slug },
          query: { tab: data.pages_categories.data[0].uuid }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/spaces_pages', {
          fields: [
            {
              pages_categories: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })
        let uuidSpacePage = data[0].pages_categories.uuid

        data = await http.get('content/pages_categories', {
          fields: [
            {
              spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidSpacePage }
        })

        const slug =
          get(data, ['data', 0, 'spaces', 'slug', 0]) ||
          get(data, ['data', 0, 'spaces', 'data', 0, 'slug', 0])

        return {
          name: 'SpacePage',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get('content/spaces_pages', {
        fields: ['uuid', { pages_categories: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: space } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: {
          'uuid:eq': pagesCategories[0]?.pages_categories?.data[0]?.uuid
        }
      })

      return {
        route: {
          name: 'SpacePage',
          params: {
            slug: space[0]?.spaces?.slug[0]
          },
          query: { tab: space[0]?.uuid }
        }
      }
    }
  },
  jobDomains: {
    add: () => ({
      name: 'JobsListingPage'
    })
  },
  jobTypes: {
    add: () => ({
      name: 'JobsListingPage'
    })
  },
  jobBranches: {
    add: () => ({
      name: 'JobsListingPage'
    })
  },
  videoBlocks: {
    add: () => ({ name: 'VideoBlocksPage' }),
    delete: () => ({ name: 'VideoBlocksPage' }),
    globalSearch: ({ data }) => {
      return {
        route: {
          name: 'VideoBlocksPage',
          query: {
            video: data.uuid
          }
        }
      }
    }
  },
  videoBlocksCategories: {
    add: () => ({ name: 'VideoBlocksPage' }),
    delete: () => ({ name: 'VideoBlocksPage' }),
    globalSearch: ({ data }) => {
      return {
        route: {
          name: 'VideoBlocksPage',
          query: {
            video_blocks_categories: data.uuid
          }
        }
      }
    }
  }
}
