import { markRaw } from 'vue'

import { IconText } from 'inside-collection/atoms'

export default {
  'inside-administration': {
    disabledAdvancedSettingsFields: [
      'events_enable_comments',
      'events_enable_likes',
    ]
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-auth': {
    loginForm: {
      userId: {
        modelName: 'name',
        inputType: 'text'
      }
    }
  },
  'inside-jobs': {
    mainContentType: 'job_offers',
    modalName: 'offers',
    modalOptions: {
      size: 'm'
    },
    categoriesFields: [
      {
        job_branches: {
          fields: ['title', 'uuid', 'icon', 'color'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      },
      {
        job_domains: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      },
      {
        job_types: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      },
      {
        locations: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      }
    ],
    fields: [
      'uuid',
      'title',
      'admin',
      'content_type',
      'content',
      { locations: ['uuid', 'title'] },
      { job_domains: ['title', 'uuid'] },
      { job_branches: ['title', 'uuid', 'icon', 'color'] },
      { job_types: ['title', 'uuid'] }
    ],
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', {
        id: 'job-details',
        class: 'job-details',
        tag: 'div',
        children: [
          {
            id: 'branches',
            class: 'branches',
            tag: markRaw(IconText),
            data: { icon: JSON.parse(data?.job_branches?.icon).name },
            value: data?.job_branches?.title
          },
          {
            id: 'location',
            class: 'location ml-s',
            tag: markRaw(IconText),
            data: { icon: 'address' },
            value: data?.locations?.title
          }
        ]
      })
    }
  },
  'inside-maps': {
    modalName: 'marker'
  },
  'inside-news': {
    bookmarkEnabled: false,
    showBookmarks: false
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    },
    shortcuts: {
      max: 6
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          'function',
          'phone',
          'mobile_phone'
        ]
      }
    }
  },
  'inside-workflows': {
    isEnabled: true
  }
}
