<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;

class CreateVideoBlocksPage extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('video_blocks_categories');
        $this->migrateContent('video_blocks');
        $this->finishUp();

        $bridge = new BridgeContent();
        $uuid = $bridge->contentInsert('custom', [
            'type' => 'node',
            'bundle' => 'custom',
            'langcode' => 'fr',
            'title' => 'Nos Videos',
            'custom_slug' => 'our-videos',
            'redirection_page' => 'VideoBlocksPage',
        ]);

        Artisan::call('models:rebuild');
    }
}
