<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Log;
use Inside\Content\Models\Contents\Groups;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;

class IntroductionGroupWysiwyg extends Migration
{
    public function up(): void
    {
        $bridgeType = new BridgeContentType();
        $bridgeType->contentTypeCreateOrUpdateField('groups', 'groups_introduction', [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'groups_introduction',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => true,
            'required'            => false,
            'weight'              => -3,
            'title'               => [
                'fr' => 'Introduction',
                'en' => 'Introduction',
            ],
            'description'         => [
                'fr' => 'Texte d\'introduction du groupe',
                'en' => 'Group\'s introduction',
            ],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => -3,
            ],
        ], -3);
        $groups = Groups::all();
        $bridge = new BridgeContent();
        foreach ($groups as $group) {
            try {
                $bridge->contentUpdate('groups', [
                    'uuid' => $group->uuid,
                    'groups_introduction' => [$group->introduction]
                ]);
            } catch (Exception $e) {
                Log::error(
                    "Copying content introduction to groups_introduction failed in migration 'introduction_group_wysiwyg' => " .$e->getMessage()
                );
            }
        }
        $bridgeType->contentTypeDeleteField('node', 'groups', 'introduction');
    }
}
