<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateLocationsAndEntitiesField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('marker', 'locations', [
            'name' => 'locations',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Localisation',
                'en' => 'Localisation',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['locations'],
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('marker', 'entities', [
            'name' => 'entities',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Localisation',
                'en' => 'Localisation',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['entities'],
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
