<?php

use Illuminate\Support\Str;

return [
    'postfilter' => function ($users) {
        return $users->reject(function ($user) {
            // If userAccountControl is 514 or 66050, the user is disabled in active directory
            if ($user->useraccountcontrol[0] == 514 || $user->useraccountcontrol[0] == 66050) {
                return true;
            }

            $excludedOU = env('GING_EXCLUDED_OU', []);
            $OUS = explode(';', $excludedOU);
            $domainsAccepted = ['groupeginger.com', 'credes.net', 'soproner.nc', 'lbtp.nc'];
            $domainMail = Str::after($user->mail[0], '@');
            if (in_array($domainMail, $domainsAccepted)) {
                if (Str::endsWith(Str::before($user->mail[0], '@'), 'ext')) {
                    return true;
                }
                foreach ($OUS as $OU) {
                    if (Str::contains($user->distinguishedname[0], $OU)) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        });
    },
];
