<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'video_blocks',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Bloc vidéo',
            'en' => 'Video Bloc',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image de Couverture',
                'en' => 'Image Cover',
            ],
            'description' => [
                'fr' => "Correspond à l'image qui s'affiche en couverture.",
                'en' => "Correspond à l'image qui s'affiche en couverture.",
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'chapo',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Sous-titre',
                'en' => 'Sub title',
            ],
            'widget' => [
                'type' => BridgeContentType::TEXT_WIDGET,
                'settings' => [
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'description',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Description',
                'en' => 'Description',
            ],
            'widget' => [
                'type' => BridgeContentType::TEXT_WIDGET,
                'settings' => [
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'video_blocks_categories',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Catégorie de bloc vidéo',
                'en' => 'Video block category',
            ],
            'description' => [
                'fr' => 'Choix de la catégorie de bloc vidéo',
                'en' => 'Choice of video block category',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['video_blocks_categories'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Lien video youtube',
                'en' => 'Youtube video link',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest figure was in 1st',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
