export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'office',
        label: 'Office'
      }
    ]
  },
  'inside-edition': {
    liveTranslateEdition: {
      enabled: true
    }
  },
  'inside-events': {
    bookmarkEnabled: false,
    calendarImportEnabled: true
  },
  'inside-jobs': {
    modalName: 'job-offers',
    extraFields: [
      'color',
      { locations: ['uuid', 'title'] },
      { departments: ['uuid', 'title'] },
      { entities: ['uuid', 'title'] },
      { functions: ['uuid', 'title'] },
      { contracts_types: ['uuid', 'title'] }
    ],
    categoriesFields: [
      {
        entities: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      },
      {
        locations: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      },
      {
        departments: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1, sort: 'title:asc' }
        }
      }
    ]
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'functions',
        class: 'function',
        data: data => data.functions?.data?.[0]?.title
      }
    ]
  },
  'inside-news': {
    bookmarkEnabled: false
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    },
    shortcuts: {
      max: 6,
      readonlyCount: 2
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/Card'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          'functions',
          'mobile_phone',
          'email'
        ]
      }
    }
  }
}
