import { http } from '@inside-library/helpers/Http'

const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type',
        'slug'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchSpace }
