<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Drupal\language\Entity\ContentLanguageSettings;
use Inside\Content\Models\Contents\JobsOffers;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Arr;

final class SwitchFunctionsOfJobsOffersToText extends Migration
{
    public function up(): void
    {
        $functionJobsOffers = JobsOffers::query()
            ->with('functions')
            ->has('functions')
            ->get()
            ->pluck('functions.*.title', 'uuid')
            ->map(fn (array $titles) => trim(Arr::first($titles)));

        $bridgeContent = new BridgeContentType();
        $bridgeContent->contentTypeDelete('functions');
        $bridgeContent->contentTypeDeleteField('node', 'jobs_offers', 'functions');

        $bridgeContent->contentTypeCreateOrUpdateField(
            type: 'jobs_offers',
            fieldName: 'function',
            options: [
                'name' => 'function',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => true,
                'search_filter' => true,
                'required' => true,
                'weight' => 4,
                'title' => [
                    'fr' => 'Fonction',
                    'nl' => 'Functie',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        Artisan::call('models:rebuild');

        $bridge = new BridgeContent();

        $functionJobsOffers->each(
            fn (string $function, string $uuid) => $bridge->contentUpdate('jobs_offers', [
                'uuid' => $uuid,
                'function' => $function
            ])
        );
    }
}
