<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Host\Bridge\BridgeContentType;
use Drupal\language\Entity\ContentLanguageSettings;

final class UpdateMarkersToBeTranslatable extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('marker');
        $this->finishUp();

        $bridge = new BridgeContentType();
        $bridge->changeFieldFormOptions('marker', 'langcode', true, 'group_advanced_options');
    }
}
