<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Functions;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

final class ReplaceFunctionsUserFieldWithFunction extends Migration
{
    public function up(): void
    {
        $contentTypeBridge = new BridgeContentType();

        $contentTypeBridge->contentTypeCreateOrUpdateField(
            'users',
            'function',
            [
                'name' => 'function',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'Fonction',
                    'nl' => 'Functie',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 8,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        Artisan::call('models:rebuild');

        $contentBridge = new BridgeContent();

        Users::each(function (Users $user) use ($contentBridge) {
            if (!$user->functions) {
                return;
            }

            $title = $user->functions->first()->title;

            if ($title) {
                $contentBridge->contentUpdate('users', [
                    'uuid' => $user->uuid,
                    'function' => $title,
                ]);
            }
        });

        $contentTypeBridge->contentTypeDeleteField('users', 'users', 'functions');
    }
}
