<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class SeedCustoms extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $customs = collect([
            [
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage',
                'title' => [
                    'fr' => 'Actualités',
                    'nl' => 'Aankomst',
                ],
            ],
            [
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage',
                'title' => [
                    'fr' => 'Événements',
                    'nl' => 'Evenementen',
                ],
            ],
            [
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage',
                'title' => [
                    'fr' => 'Annuaire',
                    'nl' => 'Adresboek',
                ],
            ],
            [
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage',
                'title' => [
                    'fr' => 'Bibliothèque de ressources',
                    'nl' => 'Bronnenbibliotheek',
                ],
            ],
            [
                'custom_slug' => 'jobs',
                'redirection_page' => 'JobsListingPage',
                'title' => [
                    'fr' => 'Offres d’emploi',
                    'nl' => 'Vacatures',
                ],
                'introduction' => [
                    'fr' => "Retrouvez toutes les offres d'emploi du groupe.  Que ce soit pour de la mobilité interne ou pour de la cooptation, n'hésitez pas à les consulter régulièrement !",
                    'nl' => "Bekijk alle vacatures binnen de groep. Of het nu gaat om interne mobiliteit of om coöptatie, aarzel niet om ze regelmatig te raadplegen!",
                ],
            ],
            [
                'custom_slug' => 'tools',
                'redirection_page' => 'ToolsPage',
                'title' => [
                    'fr' => 'Mon quotidien',
                    'nl' => 'Mijn dagelijkse routine',
                ],
            ],
            [
                'custom_slug' => 'map',
                'redirection_page' => 'MapPage',
                'title' => [
                    'fr' => 'Localisation',
                    'nl' => 'Locatie',
                ],
                'introduction' => [
                    'fr' => 'Nous sommes présents sur plusieurs lieux. Cliquez sur chaque point pour en découvrir les spécificités.',
                    'nl' => 'We zijn aanwezig op meerdere locaties. Klik op elke punt om de bijzonderheden te ontdekken.',
                ],
            ],
            [
                'custom_slug' => 'newcomers',
                'redirection_page' => 'NewcomersListingPage',
                'title' => [
                    'fr' => 'Mouvements',
                    'nl' => 'Bewegingen',
                ],
                'introduction' => [
                    'fr' => 'Retrouvez tous les nouveaux arrivants',
                    'nl' => 'Vind alle nieuwe aankomsten',
                ],
            ],
        ]);


        $locale = config('app.locale');
        $languages = collect(list_languages())->diff([$locale])->values();

        $bridge = new BridgeContent();

        $customs->each(function (array $custom) use ($bridge, $locale, $languages) {
            $original = $this->createOrUpdate($bridge, $custom, $locale);
            $original = Custom::findOrFail($original);
            $custom['uuid_host'] = $original->uuid_host;
            $languages->each(fn ($language) => $this->createOrUpdate($bridge, $custom, $language));
        });
    }

    private function createOrUpdate(BridgeContent $bridge, array $custom, string $language): ?string
    {
        $data = array_map(fn ($value) => $value[$language] ?? $value, $custom);
        $data['langcode'] = $language;

        $existing = Custom::query()
            ->where('redirection_page', $data['redirection_page'])
            ->where('langcode', $data['langcode'])
            ->first();

        if ($existing instanceof Custom) {
            $data['uuid'] = $existing->uuid;
            return $bridge->contentUpdate('custom', $data, true);
        }

        return $bridge->contentInsert('custom', $data, true, true);
    }
}
